package com.bytesbee.mysinglelivechannel.activities;


import static com.bytesbee.mysinglelivechannel.utils.Constant.FALSE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TRUE;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.view.MenuItem;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.models.Setting;
import com.bytesbee.mysinglelivechannel.utils.Constant;
import com.bytesbee.mysinglelivechannel.utils.Utils;


/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 * @noinspection ALL
 */
public class PrivacyPolicyActivity extends AppCompatActivity {

    private SwipeRefreshLayout swipeRefreshLayout;
    private Activity mActivity;

    private TextView txtAppName;
    private ImageView imgAppLogo;
    private ScrollView mScrollView;
    private WebView webView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_privacy_policy);

        mActivity = this;

        txtAppName = findViewById(R.id.txtAppName);
        imgAppLogo = findViewById(R.id.imgAppLogo);
        webView = findViewById(R.id.webView);
        webView.setBackgroundColor(0);

        WebSettings webSettings = webView.getSettings();
        webSettings.setDefaultFontSize(14);
        mScrollView = findViewById(R.id.scrollView);

        swipeRefreshLayout = findViewById(R.id.swipeRefreshLayout);
        swipeRefreshLayout.setColorSchemeResources(R.color.orange, R.color.green, R.color.blue, R.color.red);

        swipeRefreshLayout.setOnRefreshListener(() -> {
            try {
                if (Utils.isOnline(getApplicationContext())) {
                    swipeProgress(TRUE);
                    Utils.requestSettingApi(getApplicationContext(), dataHandler);
                }
            } catch (Exception e) {
                Utils.getErrors(e);
            }
        });

        setupData();
        setupToolbar();

    }

    private final Handler dataHandler = new Handler(message -> {
        if (message.what == Constant.HANDLER_SUCCESS) {
            setupData();
        }
        return true;
    });

    private void setupData() {
        try {
            swipeProgress(FALSE);
            Setting setting = SessionManager.get().getSettingModel();
            if (setting != null) {
                txtAppName.setText(setting.getApp_name());

                Utils.setSettingImageView(mActivity, setting, imgAppLogo);

                String mimeType = "text/html;charset=UTF-8";
                String encoding = "utf-8";
                String text = getString(setting);

                webView.loadDataWithBaseURL(null, text, mimeType, encoding, null);
                Utils.showBannerAd(mActivity);
                Utils.showInterstitialAds(mActivity);
                mScrollView.fullScroll(ScrollView.FOCUS_UP);
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    @NonNull
    private static String getString(Setting setting) {
        String htmlText = setting.getApp_privacy_policy();
        String rtl = SessionManager.get().isRTLOn() ? "dir=\"rtl\"" : "";

        String text = "<html><head>"
                + "<style type=\"text/css\">@font-face {font-family: MyFont;src: url(\"file:///android_res/font/poppins_regular.otf\")}body{font-family: MyFont;color: #8D8D8D;}"
                + "</style></head>"
                + "<body " + rtl + ">"
                + htmlText
                + "</body></html>";
        return text;
    }

    private void setupToolbar() {
        try {
            final Toolbar toolbar = findViewById(R.id.toolbar);
            setSupportActionBar(toolbar);
            final ActionBar actionBar = getSupportActionBar();
            if (actionBar != null) {
                getSupportActionBar().setDisplayHomeAsUpEnabled(TRUE);
                getSupportActionBar().setHomeButtonEnabled(TRUE);
                getSupportActionBar().setTitle(R.string.privacy_policy);
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    private void swipeProgress(final boolean show) {
        try {
            if (!show) {
                swipeRefreshLayout.setRefreshing(FALSE);
                return;
            }
            swipeRefreshLayout.post(() -> swipeRefreshLayout.setRefreshing(TRUE));
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        try {
            swipeProgress(FALSE);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }
}
